<?php
$meta_description = "Discover our extensive collection of quality used cars. Find your perfect vehicle with competitive prices and excellent customer service at Your Dealership Name.";
$main_image_url = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https://" : "http://" . $_SERVER['HTTP_HOST'] . '/path/to/your/hero-image.jpg'; // Update with your actual hero image path
?>

<?php include 'includes/header.php'; ?>
<head>
    
    <!-- Basic SEO -->
    <title>Torque CarDealer | Quality Used Cars for Sale</title>
    <meta name="description" content="<?php echo htmlspecialchars($meta_description); ?>">
    <meta name="keywords" content="used cars, car dealer, auto sales, vehicle dealership, car sales, used vehicles">
    
    <!-- Open Graph -->
    <meta property="og:title" content="Torque CarDealer | Quality Used Cars for Sale">
    <meta property="og:description" content="<?php echo htmlspecialchars($meta_description); ?>">
    <meta property="og:image" content="<?php echo htmlspecialchars($main_image_url); ?>">
    <meta property="og:url" content="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https://" : "http://") . $_SERVER['HTTP_HOST']; ?>">
    <meta property="og:type" content="website">
    <meta property="og:site_name" content="Your Dealership Name">
    
    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Your Dealership Name | Quality Used Cars for Sale">
    <meta name="twitter:description" content="<?php echo htmlspecialchars($meta_description); ?>">
    <meta name="twitter:image" content="<?php echo htmlspecialchars($main_image_url); ?>">
    
    <!-- Additional SEO -->
    <link rel="canonical" href="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https://" : "http://") . $_SERVER['HTTP_HOST']; ?>">
    <meta name="robots" content="index, follow">
    <meta name="author" content="Your Dealership Name">
    
    <!-- Schema.org markup for Google -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "AutoDealer",
        "name": "Torque CarDealer",
        "image": "<?php echo htmlspecialchars($main_image_url); ?>",
        "description": "<?php echo htmlspecialchars($meta_description); ?>",
        "url": "<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https://" : "http://") . $_SERVER['HTTP_HOST']; ?>",
        "address": {
            "@type": "PostalAddress",
            "streetAddress": "Your Street Address",
            "addressLocality": "Your City",
            "addressRegion": "Your State/Region",
            "postalCode": "Your Postal Code",
            "addressCountry": "Your Country"
        },
        "geo": {
            "@type": "GeoCoordinates",
            "latitude": "YOUR_LATITUDE",
            "longitude": "YOUR_LONGITUDE"
        },
        "openingHours": "Mo-Sa 09:00-18:00",
        "telephone": "Your-Phone-Number"
    }
    </script>
</head>

<?php
require_once 'config/database.php';

$database = new Database();
$db = $database->getConnection();

// Get featured cars
$featured_query = "SELECT c.*, b.name as brand_name, m.name as model_name 
                  FROM cars c 
                  LEFT JOIN brands b ON c.brand_id = b.id 
                  LEFT JOIN models m ON c.model_id = m.id 
                  WHERE c.status = 'Available' 
                  ORDER BY c.created_at DESC 
                  LIMIT 6";
$featured_cars = $db->query($featured_query)->fetchAll();

// Get brands for filter
$brands_query = "SELECT * FROM brands ORDER BY name";
$brands = $db->query($brands_query)->fetchAll();
?>

<!-- Hero Section -->
<div class="hero-section">
    <div class="hero-content">
        <h1 class="display-4 text-white mb-4">Find Your Perfect Car</h1>
        <p class="lead text-white mb-5">Discover our extensive collection of premium vehicles</p>
        <form action="cars.php" method="GET" class="search-form bg-white p-4 rounded shadow-lg" style="max-width: 1200px; margin: 0 auto;">
            <div class="row g-3 align-items-end">
                <div class="col-md-3">
                    <div class="form-group">
                        <select name="brand" class="form-select" id="brand-select">
                            <option value="">All Brands</option>
                            <?php foreach ($brands as $brand): ?>
                                <option value="<?php echo $brand['id']; ?>">
                                    <?php echo htmlspecialchars($brand['name']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <select name="model" class="form-select" id="model-select" disabled>
                            <option value="">Models</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <select name="price_range" class="form-select">
                            <option value="">Any Price</option>
                            <option value="0-10000">Under $10,000</option>
                            <option value="10000-20000">$10,000 - $20,000</option>
                            <option value="20000-30000">$20,000 - $30,000</option>
                            <option value="30000-50000">$30,000 - $50,000</option>
                            <option value="50000-999999">Over $50,000</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="fas fa-search me-2"></i>
                        Search Cars
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
document.getElementById('brand-select').addEventListener('change', function() {
    const brandId = this.value;
    const modelSelect = document.getElementById('model-select');
    
    if (brandId) {
        fetch(`get_models.php?brand_id=${brandId}`)
            .then(response => {
                if (!response.ok) {
                    throw new Error('Network response was not ok');
                }
                return response.json();
            })
            .then(models => {
                modelSelect.innerHTML = '<option value="">Select Model</option>';
                if (Array.isArray(models)) {
                    models.forEach(model => {
                        const option = document.createElement('option');
                        option.value = model.id;
                        option.textContent = model.name;
                        modelSelect.appendChild(option);
                    });
                    modelSelect.disabled = false;
                } else {
                    throw new Error('Invalid response format');
                }
            })
            .catch(error => {
                console.error('Error fetching models:', error);
                modelSelect.innerHTML = '<option value="">Error loading models</option>';
                modelSelect.disabled = true;
            });
    } else {
        modelSelect.innerHTML = '<option value="">Select Brand First</option>';
        modelSelect.disabled = true;
    }
});
</script>
<script>
document.querySelectorAll('.favorite-btn').forEach(button => {
    button.addEventListener('click', function() {
        const carId = this.dataset.carId;
        
        fetch('ajax/toggle_favorite.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: `car_id=${carId}`
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Toggle the button appearance
                this.classList.toggle('btn-danger');
                this.classList.toggle('btn-outline-danger');
            } else {
                alert('Error updating favorite status');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Error updating favorite status');
        });
    });
});
</script>
<section class="brands-section py-5 bg-light">
    <div class="container">
        <h2 class="text-center mb-4 pb-4">Popular Brands</h2>
        <div class="row g-4 justify-content-center">
            
            <div class="col-4 col-md-2">
                <div class="brand-card text-center">
                    <a href="cars.php?brand=1" class="brand-link">
                        <img src="https://www.svgrepo.com/show/446943/bmw.svg" alt="BMW" class="img-fluid mb-2 brand-img" style="max-width: 60px;">
                        <h6>BMW</h6>
                    </a>
                </div>
            </div>
            <div class="col-4 col-md-2">
                <div class="brand-card text-center">
                    <a href="cars.php?brand=3" class="brand-link">
                        <img src="https://www.svgrepo.com/show/452160/audi.svg" alt="BMW" class="img-fluid mb-2 brand-img" style="max-width: 60px;">
                        <h6>Audi</h6>
                    </a>
                </div>
            </div>
            <div class="col-4 col-md-2">
                <div class="brand-card text-center">
                    <a href="cars.php?brand=4" class="brand-link">
                        <img src="https://www.svgrepo.com/show/446899/mercedes-benz.svg" alt="Benz" class="img-fluid mb-2 brand-img" style="max-width: 60px;">
                        <h6>Benz</h6>
                    </a>
                </div>
            </div>
            <div class="col-4 col-md-2">
                <div class="brand-card text-center">
                    <a href="cars.php?brand=5" class="brand-link">
                        <img src="https://www.svgrepo.com/show/446931/toyota.svg" alt="Toyota" class="img-fluid mb-2 brand-img" style="max-width: 60px;">
                        <h6>Toyota</h6>
                    </a>
                </div>
            </div>
            <div class="col-4 col-md-2">
                <div class="brand-card text-center">
                    <a href="cars.php?brand=5" class="brand-link">
                        <img src="https://www.svgrepo.com/show/446932/volkswagen.svg" alt="Volkswagen" class="img-fluid mb-2 brand-img" style="max-width: 60px;">
                        <h6>Volkswagen</h6>
                    </a>
                </div>
            </div>
            <div class="col-4 col-md-2">
                <div class="brand-card text-center">
                    <a href="cars.php?brand=7" class="brand-link">
                        <img src="https://www.svgrepo.com/show/446930/subaru.svg" alt="Subaru" class="img-fluid mb-2 brand-img" style="max-width: 60px;">
                        <h6>Subaru</h6>
                    </a>
                </div>
            </div>
        </div>
        <style>
        .brand-img {
            transition: transform 0.3s ease-in-out;
        }
        .brand-img:hover {
            transform: scale(1.1);
        }
        .brand-link {
            text-decoration: none;
            color: inherit;
            display: block;
        }
        .brand-card {
            cursor: pointer;
        }
        </style>
    </div>
</section>

<!-- Featured Cars Section -->
<section class="featured-cars py-5">
    <div class="container">
        <h2 class="section-title text-center mb-5">Featured Vehicles</h2>
        <div class="row g-4">
            <?php foreach ($featured_cars as $car): ?>
            <div class="col-md-4">
                <div class="car-card">
                    <div class="car-image">
                        <img src="<?php echo $car['main_image']; ?>" alt="<?php echo htmlspecialchars($car['title']); ?>" class="img-fluid">
                        <div class="car-overlay">
                            <a href="car-details.php?id=<?php echo $car['id']; ?>" class="btn btn-light">View Details</a>
                            <?php if(isset($_SESSION['user_id'])): ?>
                                <button class="btn btn-outline-danger ms-2 favorite-btn" data-car-id="<?php echo $car['id']; ?>">
                                    <i class="fas fa-heart"></i>
                                </button>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="car-info p-3">
                        <h3 class="car-title"><?php echo htmlspecialchars($car['title']); ?></h3>
                        <p class="car-brand"><?php echo htmlspecialchars($car['brand_name'] . ' ' . $car['model_name']); ?></p>
                        <div class="car-details">
                            <span><i class="fas fa-calendar"></i> <?php echo $car['year']; ?></span>
                            <span><i class="fas fa-road"></i> <?php echo number_format($car['mileage']); ?> km</span>
                            <span><i class="fas fa-gas-pump"></i> <?php echo $car['fuel_type']; ?></span>
                        </div>
                        <div class="car-price mt-2">
                            <strong>$<?php echo number_format($car['price']); ?></strong>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        <div class="text-center mt-5">
            <a href="cars.php" class="btn btn-primary btn-lg">View All Cars</a>
        </div>
    </div>
</section>

<!-- Why Choose Us Section -->
<section class="why-choose-us py-5 bg-light">
    <div class="container">
        <h2 class="section-title text-center mb-5">Why Choose Us</h2>
        <div class="row g-4">
            <div class="col-md-4">
                <div class="feature-card text-center">
                    <i class="fas fa-car-side fa-3x mb-3 text-primary"></i>
                    <h3>Wide Selection</h3>
                    <p>Choose from our extensive collection of quality vehicles</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="feature-card text-center">
                    <i class="fas fa-shield-alt fa-3x mb-3 text-primary"></i>
                    <h3>Quality Guaranteed</h3>
                    <p>All vehicles undergo thorough inspection and certification</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="feature-card text-center">
                    <i class="fas fa-handshake fa-3x mb-3 text-primary"></i>
                    <h3>Expert Support</h3>
                    <p>Our team of experts is here to help you make the right choice</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Body Types Section -->
<section class="body-types-section py-5">
    <div class="container">
        <h2 class="text-center mb-4">Browse by Body Type</h2>
        <div class="row g-4">
            <?php
            $body_types = [
                ['name' => 'SUV', 'icon' => 'fa-car-side', 'image' => 'https://images.pexels.com/photos/2920064/pexels-photo-2920064.jpeg'],
                ['name' => 'Sedan', 'icon' => 'fa-car', 'image' => 'https://images.pexels.com/photos/170811/pexels-photo-170811.jpeg'],
                ['name' => 'Hatchback', 'icon' => 'fa-car-side', 'image' => 'https://images.pexels.com/photos/1007410/pexels-photo-1007410.jpeg'],
                ['name' => 'Coupe', 'icon' => 'fa-car', 'image' => 'https://images.pexels.com/photos/119435/pexels-photo-119435.jpeg'],
            ];
            foreach ($body_types as $type): ?>
                <div class="col-6 col-md-3">
                    <a href="cars.php?body_type=<?php echo urlencode($type['name']); ?>" class="body-type-card">
                        <div class="card h-100 border-0 shadow-sm">
                            <img src="<?php echo $type['image']; ?>" class="card-img-top" alt="<?php echo $type['name']; ?>"
                                 style="height: 160px; object-fit: cover;">
                            <div class="card-body text-center">
                                <i class="fas <?php echo $type['icon']; ?> mb-2"></i>
                                <h5 class="card-title mb-0"><?php echo $type['name']; ?></h5>
                            </div>
                        </div>
                    </a>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<style>
/* Hero Section */
.hero-section {
    background: linear-gradient(rgba(0,0,0,0.6), rgba(0,0,0,0.6)), url('https://images.pexels.com/photos/10548384/pexels-photo-10548384.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=1');
    background-size: cover;
    background-position: center;
    height: 600px;
    display: flex;
    align-items: center;
    justify-content: center;
    text-align: center;
    padding: 0 20px;
    margin-top: -116px;
    padding-top: 116px;
}

.hero-content {
    max-width: 800px;
}

.search-form {
    backdrop-filter: blur(10px);
    background: rgba(255,255,255,0.95) !important;
}

/* Car Cards */
.car-card {
    background: white;
    border-radius: 10px;
    overflow: hidden;
    box-shadow: 0 3px 10px rgba(0,0,0,0.1);
    transition: transform 0.3s ease;
}

.car-card:hover {
    transform: translateY(-5px);
}

.car-image {
    position: relative;
    height: 200px;
    overflow: hidden;
}

.car-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.car-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0,0,0,0.5);
    display: flex;
    align-items: center;
    justify-content: center;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.car-card:hover .car-overlay {
    opacity: 1;
}

.car-details span {
    margin-right: 15px;
    font-size: 0.9rem;
    color: #666;
}

.car-details i {
    margin-right: 5px;
}

/* Feature Cards */
.feature-card {
    padding: 30px;
    background: white;
    border-radius: 10px;
    box-shadow: 0 3px 10px rgba(0,0,0,0.1);
    transition: transform 0.3s ease;
}

.feature-card:hover {
    transform: translateY(-5px);
}

/* Section Titles */
.section-title {
    position: relative;
    padding-bottom: 15px;
}

.section-title::after {
    content: '';
    position: absolute;
    bottom: 0;
    left: 50%;
    transform: translateX(-50%);
    width: 50px;
    height: 3px;
    background: var(--primary);
}
</style>



<?php include 'includes/footer.php'; ?> 